<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SurfaceRoughness extends Model 
{

    protected $table = 'surface_roughnesses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function services()
    {
        return $this->belongsToMany('Service', 'service_surface_roughness', 'surface_roughness_id', 'service_id')->withTimestamps();
    }

}